/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.containers;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import noppes.npcs.EventHooks;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.gui.custom.components.CustomGuiSlot;
import noppes.npcs.util.CustomNPCsScheduler;

public class ContainerCustomGui
extends Container {
    public IContainer container;
    public CustomGuiWrapper customGui;
    public int cx;
    public int cy;
    public IInventory guiInventory;
    int slotCount = 0;

    public ContainerCustomGui(IInventory inventory) {
        this.guiInventory = inventory;
        this.cx = 0;
        this.cy = 0;
        this.container = Objects.requireNonNull(NpcAPI.Instance()).getIContainer(this);
    }

    void addPlayerInventory(EntityPlayer player, int x, int y) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, row, x + row * 18, y + 58));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    @Nonnull
    public Slot func_75139_a(int slotId) {
        if (slotId >= this.field_75151_b.size()) {
            return new Slot(this.guiInventory, 0, 0, 0);
        }
        return (Slot)this.field_75151_b.get(slotId);
    }

    public void setGui(CustomGuiWrapper gui, EntityPlayer player) {
        this.customGui = gui;
        if (this.customGui != null) {
            this.cx = -40 + (256 - this.customGui.getWidth()) / 2;
            this.cy = -45 + (256 - this.customGui.getHeight()) / 2;
        }
        this.slotCount = 0;
        this.field_75151_b.clear();
        for (IItemSlot slot : this.customGui.getSlots()) {
            int index;
            ++this.slotCount;
            ((CustomGuiItemSlotWrapper)slot).slot = new CustomGuiSlot(this.guiInventory, index, slot, player, this.cx, this.cy);
            ((CustomGuiItemSlotWrapper)slot).player = player;
            this.func_75146_a(slot.getMCSlot());
            this.guiInventory.func_70299_a(index, slot.getStack().getMCItemStack());
        }
        if (this.customGui.getShowPlayerInv()) {
            this.addPlayerInventory(player, this.cx + this.customGui.getPlayerInvX(), this.cy + this.customGui.getPlayerInvY());
        }
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull EntityPlayer player) {
        if (slotId < 0) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (!player.field_70170_p.field_72995_K) {
            IItemStack heldItem = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(player.field_71071_by.func_70445_o());
            if (!EventHooks.onCustomGuiSlotClicked((PlayerWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, slotId, dragType, clickTypeIn.toString(), heldItem, (Slot)this.field_75151_b.get(slotId))) {
                ItemStack item = super.func_184996_a(slotId, dragType, clickTypeIn, player);
                EntityPlayerMP p = (EntityPlayerMP)player;
                CustomNPCsScheduler.runTack(() -> p.func_71120_a((Container)this), 10);
                return item;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack2 = slot.func_75211_c();
            itemstack = itemstack2.func_77946_l();
            if (index < this.guiInventory.func_70302_i_() ? !this.func_75135_a(itemstack2, this.guiInventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack2, 0, this.guiInventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack2.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

